// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityParticle.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityParticle.h"
#include "Level.h"
#include "Application.h"




EntityParticle::EntityParticle() :
  m_ParticleType( Dobbs::EXPLOSION_BIG )
{

  m_DisplayOffset.x = 16;
  m_DisplayOffset.y = 16;

  m_DiesIfOutsideScreen = true;

}



EntityParticle::~EntityParticle() 
{
}



void EntityParticle::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_TOP:
      Die();
      break;
    case EE_DIE:
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityParticle::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  switch ( m_ParticleType )
  {
    case Dobbs::EXPLOSION_BIG:
      if ( m_StateTime >= 0.2f )
      {
        SetFrame( Dobbs::ANIM_EXPLOSION_PARTICLE_MEDIUM );
        m_Color = 0xffFFC907;
        m_DisplayOffset.x = 4;
        m_DisplayOffset.y = 4;
        m_ParticleType = Dobbs::EXPLOSION_MEDIUM;
      }
      break;
    case Dobbs::EXPLOSION_MEDIUM:
      if ( m_StateTime >= 0.4f )
      {
        SetFrame( Dobbs::ANIM_EXPLOSION_PARTICLE_SMALL );
        m_Color = 0xffDF771C;
        m_DisplayOffset.x = 8;
        m_DisplayOffset.y = 8;
        m_ParticleType = Dobbs::EXPLOSION_SMALL;
      }
      break;
  }

}



void EntityParticle::SetParticleType( Dobbs::ParticleType Type )
{

  m_ParticleType = Type;

  switch ( m_ParticleType )
  {
    case Dobbs::BUBBLE_SMALL:
      SetFrame( Dobbs::ANIM_BUBBLE_SMALL );
      SetVelY( -20.0f + ( rand() % 10 ) * 0.01f );
      m_Floating = true;
      m_LifeTime = 4.0f + ( rand() % 15 ) * 0.01f;
      break;
    case Dobbs::BUBBLE_BIG:
      SetFrame( Dobbs::ANIM_BUBBLE_BIG );
      SetVelY( -40.0f + ( rand() % 20 ) * 0.01f );
      m_Floating = true;
      m_LifeTime = 5.0f + ( rand() % 20 ) * 0.01f;
      break;
  }

}